<?php
if(!defined('sugarEntry') || !sugarEntry) die('Not A Valid Entry Point');
/*********************************************************************************
 * SugarCRM Community Edition is a customer relationship management program developed by
 * SugarCRM, Inc. Copyright (C) 2004-2013 SugarCRM Inc.

 * SuiteCRM is an extension to SugarCRM Community Edition developed by Salesagility Ltd.
 * Copyright (C) 2011 - 2014 Salesagility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SUGARCRM, SUGARCRM DISCLAIMS THE WARRANTY
 * OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License along with
 * this program; if not, see http://www.gnu.org/licenses or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301 USA.
 *
 * You can contact SugarCRM, Inc. headquarters at 10050 North Wolfe Road,
 * SW2-130, Cupertino, CA 95014, USA. or at email address contact@sugarcrm.com.
 *
 * The interactive user interfaces in modified source and object code versions
 * of this program must display Appropriate Legal Notices, as required under
 * Section 5 of the GNU Affero General Public License version 3.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License version 3,
 * these Appropriate Legal Notices must retain the display of the "Powered by
 * SugarCRM" logo and "Supercharged by SuiteCRM" logo. If the display of the logos is not
 * reasonably feasible for  technical reasons, the Appropriate Legal Notices must
 * display the words  "Powered by SugarCRM" and "Supercharged by SuiteCRM".
 ********************************************************************************/



class HelpItem {
   var $associated_field = '';
   var $title = '';
   var $text = '';
}

function &help_menu_html() {
   $str =<<<HEREDOC_END
		<div>SugarCRM Install Help</div>
		<ul>
		<li><a href="$_SERVER[PHP_SELF]?step=1">Step 1: Controllo Prerequisiti</a></li>
		<li><a href="$_SERVER[PHP_SELF]?step=2">Step 2: Configurazione Database</a></li>
		<li><a href="$_SERVER[PHP_SELF]?step=3">Step 3: Configurazione CRM</a></li>
		<li><a href="$_SERVER[PHP_SELF]?step=4">Step 4: Salvataggio file di configurazione e configurazione database</a></li>
		<li><a href="$_SERVER[PHP_SELF]?step=5">Step 5: Registrazione</a></li>
		</ul>
HEREDOC_END;
   return $str;
}

function &format_help_items(&$help_items)
{
   $str = '<table>';

   foreach($help_items as $help_item)
   {
      $str .= <<< HEREDOC_END
<tr><td><b>$help_item->title</b></td></tr>
<tr><td>$help_item->text</td></tr>
HEREDOC_END;
   }

   $str .= '</table>';

   return $str;
}

function &help_step_1_html()
{
   $help_items = array();

   $help_item = new HelpItem();
   $help_item->title = 'PHP Version';
   $help_item->text = <<< HEREDOC_END
La versione di PHP installata deve essere 4.3.x o 5.x.
HEREDOC_END;

   $help_items[] = $help_item;

   $help_item = new HelpItem();
   $help_item->title = 'Database MySQL';
   $help_item->text = <<< HEREDOC_END
Controllo che le API MySQL siano accessibili.
HEREDOC_END;

   $help_items[] = $help_item;

   $help_item = new HelpItem();
   $help_item->title = 'SuiteCRM File di Configurazione';
   $help_item->text = <<< HEREDOC_END
Il file di configurazione (config.php) deve essere scrivibile.
HEREDOC_END;

   $help_items[] = $help_item;

   $help_item = new HelpItem();
   $help_item->title = 'Cache Sotto Directories';
   $help_item->text = <<< HEREDOC_END
Tutte le sotto directories della directory di cache (cache) devono essere scrivibili.
HEREDOC_END;

   $help_items[] = $help_item;

   $help_item = new HelpItem();
   $help_item->title = 'Indirizzo Salvataggio Sessioni';
   $help_item->text = <<< HEREDOC_END
Il "session save path" specificato nel file php.ini
come session_save_path deve esistere ed essere scrivibile.
HEREDOC_END;

   $help_items[] = $help_item;

   $str =format_help_items($help_items);
   return $str;
}

function &help_step_2_html()
{
   $help_items = array();

   $help_item = new HelpItem();
   $help_item->title = 'Nome Host';
   $help_item->text = <<< HEREDOC_END
TODO
HEREDOC_END;

   $help_items[] = $help_item;

   $help_item = new HelpItem();
   $help_item->title = 'Nome Database';
   $help_item->text = <<< HEREDOC_END
TODO
HEREDOC_END;

   $help_items[] = $help_item;

   $help_item = new HelpItem();
   $help_item->title = 'Crea Database';
   $help_item->text = <<< HEREDOC_END
TODO
HEREDOC_END;

   $help_items[] = $help_item;

   $help_item = new HelpItem();
   $help_item->title = 'User Name per SuiteCRM';
   $help_item->text = <<< HEREDOC_END
TODO
HEREDOC_END;

   $help_items[] = $help_item;

   $help_item = new HelpItem();
   $help_item->title = 'Crea Utente';
   $help_item->text = <<< HEREDOC_END
TODO
HEREDOC_END;

   $help_items[] = $help_item;

   $help_item = new HelpItem();
   $help_item->title = 'Password per SuiteCRM';
   $help_item->text = <<< HEREDOC_END
TODO
HEREDOC_END;

   $help_items[] = $help_item;

   $help_item = new HelpItem();
   $help_item->title = 'Ri-Digita Password per SuiteCRM';
   $help_item->text = <<< HEREDOC_END
TODO
HEREDOC_END;

   $help_items[] = $help_item;

   $help_item = new HelpItem();
   $help_item->title = 'Cancella e ricrea le tabelle esistenti di SuiteCRM?';
   $help_item->text = <<< HEREDOC_END
TODO
HEREDOC_END;

   $help_items[] = $help_item;

   $help_item = new HelpItem();
   $help_item->title = 'Popola il database con i dati di demo?';
   $help_item->text = <<< HEREDOC_END
TODO
HEREDOC_END;

   $help_items[] = $help_item;

   $help_item = new HelpItem();
   $help_item->title = 'Utente amministratore Database';
   $help_item->text = <<< HEREDOC_END
TODO
HEREDOC_END;

   $help_items[] = $help_item;

   $help_item = new HelpItem();
   $help_item->title = 'Password Utente amministratore Database';
   $help_item->text = <<< HEREDOC_END
TODO
HEREDOC_END;

   $help_items[] = $help_item;

   $str =format_help_items($help_items);
   return $str;
}

function &help_step_3_html()
{
   $help_items = array();

   $help_item = new HelpItem();
   $help_item->title = 'URL';
   $help_item->text = <<< HEREDOC_END
TODO
HEREDOC_END;

   $help_items[] = $help_item;

   $help_item = new HelpItem();
   $help_item->title = 'SuiteCRM Password Admin';
   $help_item->text = <<< HEREDOC_END
TODO
HEREDOC_END;

   $help_items[] = $help_item;

   $help_item = new HelpItem();
   $help_item->title = 'Ri-digita SuiteCRM Password Admin';
   $help_item->text = <<< HEREDOC_END
TODO
HEREDOC_END;

   $help_items[] = $help_item;

   $help_item = new HelpItem();
   $help_item->title = 'Permetti a SugarCRM di collezionare dati anonimi sull`utilizzo del software?';
   $help_item->text = <<< HEREDOC_END
TODO
HEREDOC_END;

   $help_items[] = $help_item;

   $help_item = new HelpItem();
   $help_item->title = 'Usa una Session Directory  diversa per SuiteCRM';
   $help_item->text = <<< HEREDOC_END
TODO
HEREDOC_END;

   $help_items[] = $help_item;

   $help_item = new HelpItem();
   $help_item->title = 'Path per la Session Directory';
   $help_item->text = <<< HEREDOC_END
TODO
HEREDOC_END;

   $help_items[] = $help_item;

   $help_item = new HelpItem();
   $help_item->title = 'Fornisci Il tuo Application ID';
   $help_item->text = <<< HEREDOC_END
TODO
HEREDOC_END;

   $help_items[] = $help_item;

   $help_item = new HelpItem();
   $help_item->title = 'Application ID';
   $help_item->text = <<< HEREDOC_END
TODO
HEREDOC_END;

   $help_items[] = $help_item;

   $str =format_help_items($help_items);
   return $str;
}

function &help_step_4_html()
{
   $help_items = array();

   $help_item = new HelpItem();
   $help_item->title = 'Installa';
   $help_item->text = <<< HEREDOC_END
TODO
HEREDOC_END;

   $help_items[] = $help_item;

   $str =format_help_items($help_items);
   return $str;
}

function &help_step_5_html()
{
   $help_items = array();

   $help_item = new HelpItem();
   $help_item->title = 'Registrazione';
   $help_item->text = <<< HEREDOC_END
TODO
HEREDOC_END;

   $help_items[] = $help_item;

   $str =format_help_items($help_items);
   return $str;
}

?>

<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">
<html <?php get_language_header(); ?>>
<head>
   <meta http-equiv="Content-Type" content="text/html; charset=utf-8">
   <meta http-equiv="Content-Style-Type" content="text/css">
   <title>SugarCRM Install Help</title>
   <link rel="stylesheet" href="install/install.css" type="text/css" />
</head>
<body>
<?php
if(isset($_GET['step']))
{
   switch($_GET['step'])
   {
      case 1:
         echo help_step_1_html();
      break;
      case 2:
         echo help_step_2_html();
      break;
      case 3:
         echo help_step_3_html();
      break;
      case 4:
         echo help_step_4_html();
      break;
      case 5:
         echo help_step_5_html();
      break;
      default:
         echo help_menu_html();
      break;
   }
}
else
{
   echo help_menu_html();
}
?>

<form>
   <input type="button" value="Close" onclick="javascript:window.close();" />
</form>
</body>
</html>
