<?php

/**
 *
 * SugarCRM Community Edition is a customer relationship management program developed by
 * SugarCRM, Inc. Copyright (C) 2004-2013 SugarCRM Inc.
 *
 * SuiteCRM is an extension to SugarCRM Community Edition developed by SalesAgility Ltd.
 * Copyright (C) 2011 - 2018 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SUGARCRM, SUGARCRM DISCLAIMS THE WARRANTY
 * OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License along with
 * this program; if not, see http://www.gnu.org/licenses or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301 USA.
 *
 * You can contact SugarCRM, Inc. headquarters at 10050 North Wolfe Road,
 * SW2-130, Cupertino, CA 95014, USA. or at email address contact@sugarcrm.com.
 *
 * The interactive user interfaces in modified source and object code versions
 * of this program must display Appropriate Legal Notices, as required under
 * Section 5 of the GNU Affero General Public License version 3.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License version 3,
 * these Appropriate Legal Notices must retain the display of the "Powered by
 * SugarCRM" logo and "Supercharged by SuiteCRM" logo. If the display of the logos is not
 * reasonably feasible for technical reasons, the Appropriate Legal Notices must
 * display the words "Powered by SugarCRM" and "Supercharged by SuiteCRM".
 */


require_once('include/SugarFields/Fields/Base/SugarFieldBase.php');
require_once('modules/Currencies/Currency.php');

class SugarFieldInt extends SugarFieldBase
{
    public function formatField($rawField, $vardef)
    {
        if (!empty($vardef['disable_num_format'])) {
            return $rawField;
        }
        if ($rawField === '' || $rawField === null) {
            return '';
        }
            
        return format_number($rawField, 0, 0);
    }

    public function unformatField($formattedField, $vardef)
    {
        if ($formattedField === '' || $formattedField === null) {
            return '';
        }
        return (int)unformat_number($formattedField);
    }

    /**
     * getSearchWhereValue
     *
     * Checks and returns a sane value based on the field type that can be used when building the where clause in a
     * search form.
     *
     * @param $value Mixed value being searched on
     * @return Int the value for the where clause used in search
     */
    public function getSearchWhereValue($value)
    {
        $newVal = parent::getSearchWhereValue($value);
        if (!is_numeric($newVal)) {
            if (strpos($newVal, ',') > 0) {
                $multiVals = explode(',', $newVal);
                $newVal = '';
                foreach ($multiVals as $key => $val) {
                    if (!empty($newVal)) {
                        $newVal .= ',';
                    }
                    if (!empty($val) && !(is_numeric($val))) {
                        $newVal .= -1;
                    } else {
                        $newVal .= $val;
                    }
                }
                return $newVal;
            } else {
                return -1;
            }
        }
        return $newVal;
    }

    public function unformatSearchRequest(&$inputData, &$field)
    {
        $field['value'] = $this->unformatField($field['value'], $field);
    }

    public function getSearchViewSmarty($parentFieldArray, $vardef, $displayParams, $tabindex)
    {
        // Use the basic field type for searches, no need to format/unformat everything... for now
        $this->setup($parentFieldArray, $vardef, $displayParams, $tabindex);
        if ($this->isRangeSearchView($vardef)) {
            $id = isset($displayParams['idName']) ? $displayParams['idName'] : $vardef['name'];
            $this->ss->assign('original_id', "{$id}");
            $this->ss->assign('id_range', "range_{$id}");
            $this->ss->assign('id_range_start', "start_range_{$id}");
            $this->ss->assign('id_range_end', "end_range_{$id}");
            $this->ss->assign('id_range_choice', "{$id}_range_choice");
            if (file_exists('custom/include/SugarFields/Fields/Int/RangeSearchForm.tpl')) {
                return $this->fetch('custom/include/SugarFields/Fields/Int/RangeSearchForm.tpl');
            }
            return $this->fetch('include/SugarFields/Fields/Int/RangeSearchForm.tpl');
        }
    
        return $this->fetch($this->findTemplate('SearchForm'));
    }
    
    /**
     * @see SugarFieldBase::importSanitize()
     */
    public function importSanitize(
        $value,
        $vardef,
        $focus,
        ImportFieldSanitize $settings
        ) {
        $value = str_replace($settings->num_grp_sep, "", $value);
        if (!is_numeric($value) || strstr($value, ".")) {
            return false;
        }
        
        return $value;
    }
}
