<?php
/**
 *
 * SugarCRM Community Edition is a customer relationship management program developed by
 * SugarCRM, Inc. Copyright (C) 2004-2013 SugarCRM Inc.
 *
 * SuiteCRM is an extension to SugarCRM Community Edition developed by SalesAgility Ltd.
 * Copyright (C) 2011 - 2018 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SUGARCRM, SUGARCRM DISCLAIMS THE WARRANTY
 * OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License along with
 * this program; if not, see http://www.gnu.org/licenses or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301 USA.
 *
 * You can contact SugarCRM, Inc. headquarters at 10050 North Wolfe Road,
 * SW2-130, Cupertino, CA 95014, USA. or at email address contact@sugarcrm.com.
 *
 * The interactive user interfaces in modified source and object code versions
 * of this program must display Appropriate Legal Notices, as required under
 * Section 5 of the GNU Affero General Public License version 3.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License version 3,
 * these Appropriate Legal Notices must retain the display of the "Powered by
 * SugarCRM" logo and "Supercharged by SuiteCRM" logo. If the display of the logos is not
 * reasonably feasible for technical reasons, the Appropriate Legal Notices must
 * display the words "Powered by SugarCRM" and "Supercharged by SuiteCRM".
 */

$viewdefs ['Contacts'] =
    array(
        'DetailView' =>
            array(
                'templateMeta' =>
                    array(
                        'form' =>
                            array(
                                'buttons' =>
                                    array(
                                        'SEND_CONFIRM_OPT_IN_EMAIL' => EmailAddress::getSendConfirmOptInEmailActionLinkDefs('Contacts'),
                                        0 => 'EDIT',
                                        1 => 'DUPLICATE',
                                        2 => 'DELETE',
                                        3 => 'FIND_DUPLICATES',
                                        4 =>
                                            array(
                                                'customCode' => '<input type="submit" class="button" title="{$APP.LBL_MANAGE_SUBSCRIPTIONS}" onclick="this.form.return_module.value=\'Contacts\'; this.form.return_action.value=\'DetailView\'; this.form.return_id.value=\'{$fields.id.value}\'; this.form.action.value=\'Subscriptions\'; this.form.module.value=\'Campaigns\'; this.form.module_tab.value=\'Contacts\';" name="Manage Subscriptions" value="{$APP.LBL_MANAGE_SUBSCRIPTIONS}"/>',
                                                'sugar_html' =>
                                                    array(
                                                        'type' => 'submit',
                                                        'value' => '{$APP.LBL_MANAGE_SUBSCRIPTIONS}',
                                                        'htmlOptions' =>
                                                            array(
                                                                'class' => 'button',
                                                                'id' => 'manage_subscriptions_button',
                                                                'title' => '{$APP.LBL_MANAGE_SUBSCRIPTIONS}',
                                                                'onclick' => 'this.form.return_module.value=\'Contacts\'; this.form.return_action.value=\'DetailView\'; this.form.return_id.value=\'{$fields.id.value}\'; this.form.action.value=\'Subscriptions\'; this.form.module.value=\'Campaigns\'; this.form.module_tab.value=\'Contacts\';',
                                                                'name' => 'Manage Subscriptions',
                                                            ),
                                                    ),
                                            ),
                                        'AOS_GENLET' =>
                                            array(
                                                'customCode' => '<input type="button" class="button" onClick="showPopup();" value="{$APP.LBL_PRINT_AS_PDF}">',
                                            ),
                                        'AOP_CREATE' =>
                                            array(
                                                'customCode' => '{if !$fields.joomla_account_id.value && $AOP_PORTAL_ENABLED}<input type="submit" class="button" onClick="this.form.action.value=\'createPortalUser\';" value="{$MOD.LBL_CREATE_PORTAL_USER}"> {/if}',
                                                'sugar_html' =>
                                                    array(
                                                        'type' => 'submit',
                                                        'value' => '{$MOD.LBL_CREATE_PORTAL_USER}',
                                                        'htmlOptions' =>
                                                            array(
                                                                'title' => '{$MOD.LBL_CREATE_PORTAL_USER}',
                                                                'class' => 'button',
                                                                'onclick' => 'this.form.action.value=\'createPortalUser\';',
                                                                'name' => 'buttonCreatePortalUser',
                                                                'id' => 'createPortalUser_button',
                                                            ),
                                                        'template' => '{if !$fields.joomla_account_id.value && $AOP_PORTAL_ENABLED}[CONTENT]{/if}',
                                                    ),
                                            ),
                                        'AOP_DISABLE' =>
                                            array(
                                                'customCode' => '{if $fields.joomla_account_id.value && !$fields.portal_account_disabled.value && $AOP_PORTAL_ENABLED}<input type="submit" class="button" onClick="this.form.action.value=\'disablePortalUser\';" value="{$MOD.LBL_DISABLE_PORTAL_USER}"> {/if}',
                                                'sugar_html' =>
                                                    array(
                                                        'type' => 'submit',
                                                        'value' => '{$MOD.LBL_DISABLE_PORTAL_USER}',
                                                        'htmlOptions' =>
                                                            array(
                                                                'title' => '{$MOD.LBL_DISABLE_PORTAL_USER}',
                                                                'class' => 'button',
                                                                'onclick' => 'this.form.action.value=\'disablePortalUser\';',
                                                                'name' => 'buttonDisablePortalUser',
                                                                'id' => 'disablePortalUser_button',
                                                            ),
                                                        'template' => '{if $fields.joomla_account_id.value && !$fields.portal_account_disabled.value && $AOP_PORTAL_ENABLED}[CONTENT]{/if}',
                                                    ),
                                            ),
                                        'AOP_ENABLE' =>
                                            array(
                                                'customCode' => '{if $fields.joomla_account_id.value && $fields.portal_account_disabled.value && $AOP_PORTAL_ENABLED}<input type="submit" class="button" onClick="this.form.action.value=\'enablePortalUser\';" value="{$MOD.LBL_ENABLE_PORTAL_USER}"> {/if}',
                                                'sugar_html' =>
                                                    array(
                                                        'type' => 'submit',
                                                        'value' => '{$MOD.LBL_ENABLE_PORTAL_USER}',
                                                        'htmlOptions' =>
                                                            array(
                                                                'title' => '{$MOD.LBL_ENABLE_PORTAL_USER}',
                                                                'class' => 'button',
                                                                'onclick' => 'this.form.action.value=\'enablePortalUser\';',
                                                                'name' => 'buttonENablePortalUser',
                                                                'id' => 'enablePortalUser_button',
                                                            ),
                                                        'template' => '{if $fields.joomla_account_id.value && $fields.portal_account_disabled.value && $AOP_PORTAL_ENABLED}[CONTENT]{/if}',
                                                    ),
                                            ),
                                    ),
                            ),
                        'maxColumns' => '2',
                        'widths' =>
                            array(
                                0 =>
                                    array(
                                        'label' => '10',
                                        'field' => '30',
                                    ),
                                1 =>
                                    array(
                                        'label' => '10',
                                        'field' => '30',
                                    ),
                            ),
                        'includes' =>
                            array(
                                0 =>
                                    array(
                                        'file' => 'modules/Contacts/Contact.js',
                                    ),
                            ),
                        'useTabs' => true,
                        'tabDefs' =>
                            array(
                                'LBL_CONTACT_INFORMATION' =>
                                    array(
                                        'newTab' => true,
                                        'panelDefault' => 'expanded',
                                    ),
                                'LBL_PANEL_ADVANCED' =>
                                    array(
                                        'newTab' => true,
                                        'panelDefault' => 'expanded',
                                    ),
                                'LBL_PANEL_ASSIGNMENT' =>
                                    array(
                                        'newTab' => true,
                                        'panelDefault' => 'expanded',
                                    ),
                            ),
                    ),
                'summaryTemplates' => [
                    'edit' => 'LBL_SUMMARY_PERSON',
                    'detail' => 'LBL_SUMMARY_PERSON',
                ],
                'topWidget' => [
                    'type' => 'statistics',
                    'options' => [
                        'statistics' => [
                            [
                                'labelKey' => '',
                                'type' => 'contact-last-touchpoint',
                                'hideValueIfEmpty' => true
                            ],
                        ],
                    ],
                    'acls' => [
                        'Contacts' => ['view', 'list']
                    ]
                ],
                'sidebarWidgets' => [
                    [
                        'type' => 'history-timeline',
                        'acls' => [
                            'Contacts' => ['view', 'list']
                        ]
                    ]
                ],
                'recordActions' => [
                    'actions' => [
                        'print-as-pdf' => [
                            'key' => 'print-as-pdf',
                            'labelKey' => 'LBL_PRINT_AS_PDF',
                            'asyncProcess' => true,
                            'modes' => ['detail'],
                            'acl' => ['view'],
                            'aclModule' => 'AOS_PDF_Templates',
                            'params' => [
                                'selectModal' => [
                                    'module' => 'AOS_PDF_Templates'
                                ]
                            ]
                        ]
                    ]
                ],
                'panels' =>
                    array(
                        'lbl_contact_information' =>
                            array(
                                0 =>
                                    array(
                                        0 =>
                                            array(
                                                'name' => 'full_name',
                                                'label' => 'LBL_NAME',
                                            ),
                                        1 => '',
                                    ),
                                1 =>
                                    array(
                                        0 =>
                                            array(
                                                'name' => 'phone_work',
                                                'label' => 'LBL_OFFICE_PHONE',
                                            ),
                                        1 =>
                                            array(
                                                'name' => 'phone_mobile',
                                                'label' => 'LBL_MOBILE_PHONE',
                                            ),
                                    ),
                                2 =>
                                    array(
                                        0 =>
                                            array(
                                                'name' => 'title',
                                                'comment' => 'The title of the contact',
                                                'label' => 'LBL_TITLE',
                                            ),
                                        1 =>
                                            array(
                                                'name' => 'department',
                                                'label' => 'LBL_DEPARTMENT',
                                            ),
                                    ),
                                3 =>
                                    array(
                                        0 =>
                                            array(
                                                'name' => 'account_name',
                                                'label' => 'LBL_ACCOUNT_NAME',
                                            ),
                                        1 =>
                                            array(
                                                'name' => 'phone_fax',
                                                'label' => 'LBL_FAX_PHONE',
                                            ),
                                    ),
                                4 =>
                                    array(
                                        0 =>
                                            array(
                                                'name' => 'email1',
                                                'studio' => 'false',
                                                'label' => 'LBL_EMAIL_ADDRESS',
                                            ),
                                    ),
                                5 =>
                                    array(
                                        0 =>
                                            array(
                                                'name' => 'primary_address_street',
                                                'label' => 'LBL_PRIMARY_ADDRESS',
                                                'type' => 'address',
                                                'displayParams' =>
                                                    array(
                                                        'key' => 'primary',
                                                    ),
                                            ),
                                        1 =>
                                            array(
                                                'name' => 'alt_address_street',
                                                'label' => 'LBL_ALTERNATE_ADDRESS',
                                                'type' => 'address',
                                                'displayParams' =>
                                                    array(
                                                        'key' => 'alt',
                                                    ),
                                            ),
                                    ),
                                6 =>
                                    array(
                                        0 =>
                                            array(
                                                'name' => 'description',
                                                'comment' => 'Full text of the note',
                                                'label' => 'LBL_DESCRIPTION',
                                            ),
                                        1 => '',
                                    ),
                                7 =>
                                    array(
                                        0 =>
                                            array(
                                                'name' => 'assigned_user_name',
                                                'label' => 'LBL_ASSIGNED_TO_NAME',
                                            ),
                                    ),
                            ),
                        'LBL_PANEL_ADVANCED' =>
                            array(
                                0 =>
                                    array(
                                        0 =>
                                            array(
                                                'name' => 'lead_source',
                                                'comment' => 'How did the contact come about',
                                                'label' => 'LBL_LEAD_SOURCE',
                                            ),
                                    ),
                                1 =>
                                    array(
                                        0 =>
                                            array(
                                                'name' => 'report_to_name',
                                                'label' => 'LBL_REPORTS_TO',
                                            ),
                                        1 =>
                                            array(
                                                'name' => 'campaign_name',
                                                'label' => 'LBL_CAMPAIGN',
                                            ),
                                    ),
                            ),
                        'LBL_PANEL_ASSIGNMENT' =>
                            array(
                                0 =>
                                    array(
                                        0 =>
                                            array(
                                                'name' => 'date_entered',
                                                'customCode' => '{$fields.date_entered.value} {$APP.LBL_BY} {$fields.created_by_name.value}',
                                                'label' => 'LBL_DATE_ENTERED',
                                            ),
                                        1 =>
                                            array(
                                                'name' => 'date_modified',
                                                'customCode' => '{$fields.date_modified.value} {$APP.LBL_BY} {$fields.modified_by_name.value}',
                                                'label' => 'LBL_DATE_MODIFIED',
                                            ),
                                    ),
                            ),
                    ),
            ),
    );
